﻿/*	VERSION:	2.2

DEPENDENCIES:
	nestedEval.as
		evalPath.as
			getImpliedValue.as
			resolveContainer.as

USAGE:
	#include "functions/nestedEval.as"
	myObj.var1 = 1.1;
	string = "[Math.ceil([myObj.var1])]";
	result = nestedEval( string, "RAM", "_this" );

DESCRIPTION:	
	This evaluates variable paths contained in [], and outputs the resulting string.
		"myvar = [myVar]"  ->  "myvar = value"
	This also calls functions contained within []
		"[Math.ciel(1.1)]"  ->  "2"
	
	This accepts both full paths, or relative paths.
	Relative paths are assumed to be located within the specified 'defaultContainer_str"
	If no "defaultContainer_str" is specified, relative paths are assumed to be local variables within "this"
	"defaultContainer_str" is an optional parameter.
	Full paths are automatically detected.
*/
#include "evalPath.as"
//	getImpliedValue
//	resolveContainer
function nestedEval( inputPath, defaultContainer_str, thisName )
{
	if( typeof(inputPath) == "string" )
	{// if;  input is a string
		var thisName = (thisName) ? thisName : "this";
		var inputPath = String(inputPath);
		var output = "";
		// resolve defaultContainer_str
		if(!defaultContainer_str)
			var defaultContainer_str = "this";
		// divide path into array
		var path_array = inputPath.split("[");
		// loop backwards through array  (skip 1st element)
		for(var i=path_array.length-1; i>0; i--)
		{
			var thisPart = path_array[i] +output;
			// find 1st ]
			var endAt = thisPart.indexOf("]");
			// append remaining string to beginning
			output = thisPart.substr(endAt+1);
			// eval the contents before the ]
			var innerPart = thisPart.substr(0,endAt);
			var result = evalPath( innerPart, defaultContainer_str, thisName );
			
			// append result to beginning
			if( result instanceof Object  &&  i==1  &&  output.length==0 )
			{// if:  The final result is an object,  and there is no string before or after it
				// output the result as its actual data-type
				output = result;
			}else
			{// if:  There is text after the result, then display the result as text
				output = result + output;
			}
		}// for: each eval group  (moving backwards)
		
		// prepend all text before the first [ bracket,  to the beginning of the output
		if( output instanceof Object  &&  path_array[0]=="" )
		{// if:  The output is an object, and there is no text preceeding it
			// leave overall output as an object
		}else{
			// append output as a string
			output = path_array[0] +output;
		}
	}// if;  input is a string
	else
	{// if;  input is NOT a string
		var output = inputPath;
	}// if;  input is NOT a string
	// return resulting string
	return output;
}// nestedEval()